from .paths import FluidLabPaths


class FluidLabNaming:
    _FLUIDLAB_name = FluidLabPaths.ROOT_BASENAME.title()  # <- FLUIDLAB
    _fluidlab_name = _FLUIDLAB_name.lower()  # <- fluidlab
    _FluidLab_name = _FLUIDLAB_name[:-3] + _fluidlab_name[-3:].title()  # <- FluidLab

    FluidLab = _FluidLab_name

    # Working with:
    WORKING_WITH = "Working with: "

    # Objects:
    PARTICLE_INSTANCER_OB = FluidLab + "_particle_instancer_ob"
    ALIVE = FluidLab + "_alive"
    DEAD = FluidLab + "_dead"

    # Modifiers:
    PARTICLE_INSTANCE_ALIVE_MOD = FluidLab + "_ParticleInstance_Alive"
    PARTICLE_INSTANCE_DEAD_MOD = FluidLab + "_ParticleInstance_Dead"
    SMOOTH_MOD = FluidLab + "_Smooth"
    COLLISION_MOD = FluidLab + "_Collision"
    COLLISION_MOD_GN = FluidLab + "_Collision_GN"
    
    # GN Modifiers:
    GN_MESH_MOD = FluidLab + "_Mesh_Mod"
    GN_PART_ATTRS_MOD = FluidLab + "_Particles_Attributes_Mod"

    # Node Groups:
    GN_MESH = FluidLab + "_Mesh_GN"
    GN_PART_ATTRS = FluidLab + "_Particles_Attributes_GN"
    NG_GNT = "GeometryNodeTree"

    PS_NAME = "FLab_Particles"

    # COLLECTIONS:
    MAIN_COLL = _FluidLab_name
    FLUID_GROUPS_COLL = "Fluid_Groups"
    VERTEX_COLL = "Vertex"
    MESHES_COLL = "Meshes"
    GROUP_PREFIX = "G_" # GRP_
    VERTEX_PREFIX = "V_" # VRTX_
    MESH_PREFIX = "M_" # MESH_
    EXPORTS_ABC = _FluidLab_name + "_ABC"
    EXPORTS_USD = _FluidLab_name + "_USD"
    GN_COLLIDERS = "GNodes-Colliders"

    MAIN_FORCES_COLL = "FL_Forces"
    FORCES_GROUP_COLL = "FL_Force_Group"
    
    # Marcajes de collections internos:
    _GROUPS_COLL = FLUID_GROUPS_COLL + "_coll"
    _VERTEX_COLL = VERTEX_COLL + "_coll"

    # OBJECTS:
    EMITTER_OB = _FluidLab_name + "_emitter_ob"
    PREV_STATUS_PS_MOD = _FluidLab_name + "_prev_status_ps_mod"

    FORCE_OB = "Force"
    FORCE_OB_01 = FORCE_OB + "_01"
    FFIELD_NAME = "FField"
    FFPARENTED = _FluidLab_name + "_force_field_parented"
    FF_HANDLER = _FluidLab_name + "_FF_Handler"

    # WM
    WM_POPUP_OPENED = _FluidLab_name + "_popup_opened"
    WM_BAKE_POPUP_OPENED = _FluidLab_name + "_bake_popup_opened"


    # MISC:
    COLLIDER_TYPE_OB = 'MESH_CUBE'
    COLLIDER_TYPE_LIST = 'OUTLINER_COLLECTION'

    # Materials:
    FLUIDLAB_MAT = _FluidLab_name + "_mat"
    MAT_BASIC_GRAIN = _FluidLab_name + "_Basic_Shader_Grain"
    MAT_BLEND_BASIC = "Basic_mat"

    # WORLD:
    WORLD = _FluidLab_name + "_World"
    WORLD_MIX = _FluidLab_name + "_World_Mix"
    WORLD_BACKGROUND = _FluidLab_name + "_World_Background"
    WORLD_ENV_TEXT = _FluidLab_name + "_World_Environment_Texture"

    # Generic feedback:
    NO_MESHES_AVAIL = "No meshes available at the moment!"
    NO_COLLIDERS_AVAIL = "No colliders available at the moment!"

    # Modifiers:
    DP_CANVAS_MOD = 'FLUIDLAB_DP'
    ACT_VG_DP_WEIGHT = _FluidLab_name + "_dp_weight"

    # Force Weights names:
    weights = ["gravity", "all", "force", "vortex", "magnetic", "harmonic", "charge", "lennardjones", "wind", "curve_guide", "texture", "smokeflow", "turbulence", "drag", "boid"]

    # Start Simulation Start/Stop Control
    # SS_SRT_STP = 'START_SIMULATION' 

    # Materials
    MIXES_PREFIX = "FluidLabMix_"
    ITERATIONS_BLUR_NODE = "Blur_Colors"
    POWER_BLUR_NODE = "Blur_Colors"
    EPSILONS_NODE = "Epsilons"
    INDEX_SW_COLORS = "Array_Colors"